--------------------------------------------------------------------------------
--
-- $Header: rdbms/demo/dmsh.sql /main/9 2012/04/15 16:31:57 xbarr Exp $
--
-- dmsh.sql
--
-- Copyright (c) 2001, 2012, Oracle and/or its affiliates. 
-- All rights reserved. 
--
--    NAME
--    dmsh.sql
--
--    DESCRIPTION
--      This script creates views and tables using SH data
--      in the schema of the data mining user. These tables/views
--      are the datasets used by the Oracle Data Mining demo programs.
--      This script also creates a text policy for text mining.
--    NOTES
--       The script assumes that the full SH schema is already created and the
--       necessary SELECTs have been granted (See dmshgrants.sql). This script runs in 
--       the schema of the data mining user.
--       mining_data_*_v views : Used for mining (no text)
--       mining_*_text views: Used for mining with text 
--
--    MODIFIED   (MM/DD/YY)
--       amozes      01/23/12 - updates for 12c
--       xbarr       11/12/10 - change mining_*_nested_text tables to views
--       ktaylor     07/11/05 - minor edits to comments
--       xbarr       03/14/05 - add purge for object drop 
--       cbhagwat    11/09/04 - Using collect 
--       bmilenov    10/20/04 - Add one-class demo view 
--       cbhagwat    09/17/04 - Bug 3881118 
--       xbarr       08/17/04 - create view for OC
--       xbarr       06/25/04 - xbarr_dm_rdbms_migration
--       cbhagwat    11/11/03 - Text NMF_CLUSTERING => SVM_CLASSIFIER
--       cbhagwat    10/10/03 - Remove DROPs
--       cbhagwat    10/10/03 - Remove Sh grants
--       cbhagwat    10/09/03 - Add nested table creatin using Text tf
--       cbhagwat    10/08/03 - cbhagwat_txn109150
--       cbhagwat    10/08/03 - creation
--
--------------------------------------------------------------------------------
--
-- Creates data mining views on SH data
--

--------------------------------------------------------------------------------
-- View to join and filter data
-- CUST_YEAR_OF_BIRTH column is transformed to an AGE
CREATE OR REPLACE VIEW mining_data AS
SELECT
 a.CUST_ID, a.CUST_GENDER,
 2003-a.CUST_YEAR_OF_BIRTH AGE,
 a.CUST_MARITAL_STATUS, c.COUNTRY_NAME, a.CUST_INCOME_LEVEL, b.EDUCATION,
 b.OCCUPATION, b.HOUSEHOLD_SIZE, b.YRS_RESIDENCE, b.AFFINITY_CARD,
 b.BULK_PACK_DISKETTES, b.FLAT_PANEL_MONITOR, b.HOME_THEATER_PACKAGE,
 b.BOOKKEEPING_APPLICATION, b.PRINTER_SUPPLIES, b.Y_BOX_GAMES,
 b.os_doc_set_kanji, b.comments 
FROM
 sh.customers a,
 sh.supplementary_demographics b,
 sh.countries c
WHERE
 a.CUST_ID = b.CUST_ID
 AND a.country_id  = c.country_id
 AND a.cust_id between 100001 and 104500;

--------------------------------------------------------------------------------
-- Build, test, and apply views (with text)
-- Build, test, and apply datasets are made non-overlapping by using
-- a predicate on cust_id.

CREATE OR REPLACE VIEW mining_build_text AS
SELECT *
FROM mining_data
WHERE cust_id between 101501 and 103000;

CREATE OR REPLACE VIEW mining_test_text AS
SELECT *
FROM mining_data
WHERE cust_id between 103001 and 104500;

CREATE OR REPLACE VIEW mining_apply_text AS
SELECT *
FROM mining_data
WHERE cust_id between 100001 and 101500;

--------------------------------------------------------------------------------
-- Build, test, and apply views
-- Same as above, but no text - COMMENTS column removed

CREATE OR REPLACE VIEW mining_data_build_v AS
SELECT CUST_ID, CUST_GENDER, AGE, CUST_MARITAL_STATUS, COUNTRY_NAME,
 CUST_INCOME_LEVEL, EDUCATION, OCCUPATION, HOUSEHOLD_SIZE,
 YRS_RESIDENCE, AFFINITY_CARD, BULK_PACK_DISKETTES, FLAT_PANEL_MONITOR,
 HOME_THEATER_PACKAGE, BOOKKEEPING_APPLICATION, PRINTER_SUPPLIES,
 Y_BOX_GAMES, OS_DOC_SET_KANJI
FROM mining_build_text;

CREATE OR REPLACE VIEW mining_data_test_v AS
SELECT CUST_ID, CUST_GENDER, AGE, CUST_MARITAL_STATUS, COUNTRY_NAME,
 CUST_INCOME_LEVEL, EDUCATION, OCCUPATION, HOUSEHOLD_SIZE,
 YRS_RESIDENCE, AFFINITY_CARD, BULK_PACK_DISKETTES, FLAT_PANEL_MONITOR,
 HOME_THEATER_PACKAGE, BOOKKEEPING_APPLICATION, PRINTER_SUPPLIES,
 Y_BOX_GAMES, OS_DOC_SET_KANJI
FROM mining_test_text;

CREATE OR REPLACE VIEW mining_data_apply_v AS
SELECT CUST_ID, CUST_GENDER, AGE, CUST_MARITAL_STATUS, COUNTRY_NAME,
 CUST_INCOME_LEVEL, EDUCATION, OCCUPATION, HOUSEHOLD_SIZE,
 YRS_RESIDENCE, AFFINITY_CARD, BULK_PACK_DISKETTES, FLAT_PANEL_MONITOR,
 HOME_THEATER_PACKAGE, BOOKKEEPING_APPLICATION, PRINTER_SUPPLIES,
 Y_BOX_GAMES, OS_DOC_SET_KANJI
FROM mining_apply_text;

--------------------------------------------------------------------------------
-- Data for one class model
-- Only data for positive affinity card (one class) is used.

CREATE OR REPLACE VIEW mining_data_one_class_v AS
SELECT CUST_ID, CUST_GENDER, AGE, CUST_MARITAL_STATUS, COUNTRY_NAME,
 CUST_INCOME_LEVEL, EDUCATION, OCCUPATION, HOUSEHOLD_SIZE, YRS_RESIDENCE
FROM mining_data_build_v
WHERE affinity_card = 1;
